#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <ShlGuid.H>
#include <ObjBase.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <String.H>

//////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NSWFL.H"

#include "Headers/Definitions.H"
#include "Headers/Service.H"

//////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR CmdLine, int nCmdShow )
{
	MainInstance = hInstance;

    if(strlen(CmdLine) < 0)
    {
        return 0;
    }

    //-------------------------------------------------------------------------------------------------------------    

    if( strcmp(LCase(CmdLine), "/install") == 0)
    {
    	char Path[257];
        char Application[257];
    	unsigned long SizeOfPath = sizeof(Path);

    	short ServiceInstalled = xIsServiceInstalled(ThisServiceName);

		if( ServiceInstalled == _Yes_ )
		{
    		MessageBox(NULL, "The SQLBackup service is already installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

    	if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "Path", Path, SizeOfPath))
    	{
    		MessageBox(NULL, "Failed to obtain required registry values.", TitleCaption, MB_ICONINFORMATION );
    		return FALSE;
    	}

    	sprintf(Application, "%s\\%s", Path, "SQLBackup.Exe");

		if ( xInstallService(ThisServiceName, ThisDisplayName, Application) == _Success_ )
		{
//			MessageBox(NULL, "The SQLBackup service was installed sucessfully.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}
		else{
			MessageBox(NULL, "Failed to install the SQLBackup service.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

        return 0;
    }

    //-------------------------------------------------------------------------------------------------------------    

    if( strcmp(LCase(CmdLine), "/start") == 0)
    {
    	short ServiceInstalled = xIsServiceInstalled(ThisServiceName);

		if( ServiceInstalled == _No_ )
		{
    		MessageBox(NULL, "The SQLBackup service is not installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}
		if(xStartService(ThisServiceName) == _Success_)
        {
//    		MessageBox(NULL, "The SQLBackup service was started sucessfully.", TitleCaption, MB_ICONINFORMATION );
            return 0;
        }
        else{
    		MessageBox(NULL, "Failed to start the SQLBackup service.", TitleCaption, MB_ICONINFORMATION );
   			return 0;
        }

        return 0;
    }

    //-------------------------------------------------------------------------------------------------------------    

    if( strcmp(LCase(CmdLine), "/delete") == 0)
    {
    	short ServiceInstalled = xIsServiceInstalled(ThisServiceName);

		if( ServiceInstalled == _No_ )
		{
//    		MessageBox(NULL, "The SQLBackup service is not installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

    	if( xUninstallService(ThisServiceName) == _Success_ )
    	{
//    		MessageBox(NULL, "The SQLBackup service was marked for deletion.", TitleCaption, MB_ICONINFORMATION );
    		return 0;
       	}
        else{
    		MessageBox(NULL, "Failed to mark the SQLBackup service for deletion.", TitleCaption, MB_ICONINFORMATION );
            return 0;
        }

        return 0;
    }

    //-------------------------------------------------------------------------------------------------------------

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////

